#ifndef _FLORA_H
#define _FLORA_H

#include "uniformPerFrameConstants.h"
#include "settings.txt"

#define FC FOG_COLOR
#define PI 3.1415926535
#define mxzo(x) max(x, 0.)
#define saturate(x) clamp(x, 0., 1.)
#define rain smoothstep(.6,.3,FOG_CONTROL.x)
#define dp(x) dot(x,x)
#define ih vec3(1.,0.,0.)
#define jh vec3(0.,1.,0.)
#define kh vec3(0.,0.,1.)

#define ender (dp(FC.rgb*2.5)<.05)
#define nether ((dp(FC.rgb*2.)<0.9 ||(dp(FC.rgb*2.)<1.5&&FC.b<FC.r*1.3))&&FOG_CONTROL.x<0.1)
#define onether (nether==true&&ender==false)

#ifdef dynamic
#if (ALWAYSTIME==1)
#define tp PI*2.+2.7+TIMEADD
#elif (ALWAYSTIME==2)
#define tp PI*2.+1.5+TIMEADD
#elif (ALWAYSTIME==3)
#define tp PI*2.-.3+TIMEADD
#else 
#define tp TIME*0.005*((nether)?0.:1.)*TIMESPEED+2.1+PI*2.+TIMEADD
#endif
#define sunpos normalize(vec3(sin(tp),-cos(tp)*.85,-cos(tp)*.5))
#endif

#define sline(x,y) smoothstep(x, y, skp)
#define slu sline(0.0, 1.0)
#define sld sline(0.75, 1.0)

#define bsa vec3(0.30588,0.41961,0.53725)
#define bsb vec3(0.49803,0.65882,0.76862)
#define bsc vec3(0.03529,0.19686,0.27058)
#define bsd vec3(0.26745,0.19862,0.28098)
#define bse vec3(0.89019,0.50588,0.71176)

#define dhr vec3(0.68627,0.71372,0.69019)
#define shr vec3(0.70022,0.55594,0.23862)
#define ushr(x) mix(bse*0.5,shr,x)
#define nhr bsb * 0.2976 *0.6

#define dsk mix( bsa, bsb, slu)
#define nsk mix( bsc * 0.648, (bsc + bsa) * 0.288 , slu)*0.6
#define rsk mix(vec3(0.7), vec3(0.65), slu)
#define ssk mix( bsc * (ih+(jh+kh)*1.1) * 0.96, bsb * 0.74, slu)
#define usk mix(mix(bse*.5, ushr(.6), slu), ushr(.9), sld)*.6

#ifdef dynamic
#define dd saturate((sunpos.y-.85)*.5882+1.)
#define ssd saturate(pow(abs(sunpos.x),10.))
#else
#define dd saturate(dp(FC.rgb)*5.)
#define ssd saturate(0.3+FC.r-FC.b)
#endif

#define smix(x,y,z,w) mix(y, mix(mix(x, z, ssd), w, rain), dd)

#define skh smix(dhr, nhr, shr, vec3(0.68))
#define skc smix(dsk, nsk, ssk, rsk)

#ifdef dynamic
#define tmc1 ((ender)?0.3:0.23)
#define tmc2 ((ender)?.05:.0)
#else
#define tmc1 mix(0.26,0.23,dd)
#define tmc2 0.
#endif

vec3 tonemap(vec3 color){
  vec3 lit = exp(-1./(color+tmc1));
  color = pow(lit,1.-lit);
  color = color/(color+vec3(0.62232,0.61840+tmc2,0.62997));
  color = pow(color,1.-color);
  return color;
}

#endif
